/* ==================================================
   TgTake2 project
   Created: Geoff R. McLane - Aug 2011
   License: GPL2 (or later)
   ================================================== */
#ifndef TABSETUP_H
#define TABSETUP_H

#include <QWidget>
#include <QVBoxLayout>
#include <QGroupBox>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QSettings>
#include <QDir>
#include <QString>
#include <QFileDialog>
#include <QStatusBar>

class MainWindow;

// setup_state flags
#define suf_scene   0x00000001
#define suf_tools   0x00000002
#define suf_root    0x00000004
#define suf_ranges  0x00000008
#define suf_ok (suf_scene | suf_tools | suf_root | suf_ranges)

class tabSetup : public QWidget
{
    Q_OBJECT
public:
    explicit tabSetup(QWidget *parent = 0);

    MainWindow *main;
    QLabel *projdirLabel;
    QLineEdit * projdirEdit;
    QPushButton *projdirBrowse;

    QLabel *tgtoolLabel;
    QLineEdit *tgtoolEdit;
    QPushButton *tgtoolBrowse;

    QLabel *fgrootLabel;
    QLineEdit *fgrootEdit;
    QPushButton *fgrootBrowse;

    void saveSetting(QString path, QString value);

    QLabel *mmLabel;
    QLabel *minLabel; // "Minimum"
    QLabel *maxLabel; // "Maximum"

    QLabel *latLabel; // "Latitude:"
    QLineEdit *minlatEdit;
    QLineEdit *maxlatEdit;

    QLabel *lonLabel; // "Longitude:"
    QLineEdit *minlonEdit;
    QLineEdit *maxlonEdit;

    QLabel *centlat1Label;
    QLabel *centlat2Label;
    QLabel *centlon1Label;
    QLabel *centlon2Label;
    QLabel *xdist1Label;
    QLabel *xdist2Label;
    QLabel *ydist1Label;
    QLabel *ydist2Label;

    QLabel *srtm1Label;
    QLabel *srtm2Label;
    QLabel *srtm3Label;
    QLabel *srtm4Label;

    int setup_state;

signals:

public slots:
    void on_projdir_edit();
    void on_projdir_browse();
    void on_tgtool_edit();
    void on_tgtool_browse();
    void on_fgroot_edit();
    void on_fgroot_browse();
    void on_range_change();
    void validate_dirs();


};

#endif // TABSETUP_H
