#!/bin/sh
#< zip-test.sh - zip the source
. wait_for.sh

TEMPV=0.0.1
#@REM Begins at 2011-08-28
PROJ="TgTake2"
if [ ! -f "../$PROJ/zip-test.sh" ]; then
    echo "ERROR: Not in correct folder... Can NOT find self..."
    exit 1
fi

delbu -r

TEMPZ="$PROJ-$TEMPV-src.zip"
TEMPS="$PROJ"
TEMPX="-x=$TEMPS/$TEMPS-build-desktop/* -x=$TEMPS/src/$TEMPS.pro.user"
TEMPO=""
if [ -f "../$TEMPZ" ]; then
    echo "This is an UPDATE"
    TEMPO="-u"
fi
echo "RUN: zip $TEMPO -o -r $TEMPX $TEMPZ $TEMPS/*"
wait_for_input "$BN: Continue?"

cd ..
echo "In current directory [$(pwd)]"
if [ ! -d "$TEMPS" ]; then
    echo "ERROR: Can NOT locate $TEMPS folder!"
    exit 1
fi

echo "Doing: zip $TEMPO -o -r $TEMPX $TEMPZ $TEMPS/*"

zip $TEMPO -o -r $TEMPX $TEMPZ $TEMPS/*

if [ ! -f "$TEMPZ" ]; then
    echo "$BN: FAILED to create zip $TEMPZ"
    exit 1
fi

cd $TEMPS
ls -l "../$TEMPZ"

